var MILLISECONDS = 0;
var CMITIMESPAN = 1;

function TimeSpan()
{
	this.startTime = new Date();
	this.getElapsed = TimeSpanGetElapsed;
}

// This member function of the TimeSpan
// object will return, in SCORM CMITimespan
// form, the elapsed time from the time the
// object was created to the time the function
// was called.
function TimeSpanGetElapsed(timeFormat)
{
	if (timeFormat == null)
	{
		timeFormat = MILLISECONDS;
	}
	var retVal = "";
	var milliseconds = 0;
	
	// Set milliseconds equal to the number of milliseconds
	// between creation of this object and this function call.
	milliseconds = (new Date()).getTime() - this.startTime.getTime();
	
	switch (timeFormat)
	{
		case 0:return milliseconds;
		case 1:return getTimespan(milliseconds);
		default:alert("Illegal format supplied in call to TimeSpan.getElapsed().");return 0;
	}
}

function getTimespan(milliseconds)
{
	var retVal = "";
	var hours = 0;
	var minutes = 0;
	var seconds = 0;
	var hundreths = 0;
	
	hours = Math.floor(milliseconds/3600000);
	milliseconds -= hours*3600000;

	minutes = Math.floor(milliseconds/60000);
	milliseconds -= minutes*60000;

	seconds = Math.floor(milliseconds/1000);
	milliseconds -= seconds*1000;

	hundreths = Math.floor(milliseconds/10);
	milliseconds -= hundreths*10;
	
	if (hours > 9999)
	{
		hours = 0;
	}
	
	if (hours < 10)
	{
		hours = "0" + hours;
	}
	else
	{
		hours += "";
	}
	
	if (minutes < 10)
	{
		minutes = "0" + minutes;
	}
	else
	{
		minutes += "";
	}
	
	if (seconds < 10)
	{
		seconds = "0" + seconds;
	}
	else
	{
		seconds += "";
	}
	
	if (hundreths < 10)
	{
		hundreths = "0" + hundreths;
	}
	else
	{
		hundreths +="";
	}
	
	return hours + ":" + minutes + ":" + seconds + "." + hundreths;
}
